function varargout = localMaximum(x,minDist)
% function varargout = localMaximum(x,minDist)
%
% This function returns the indexes\subscripts of local maximum in the data x.
% x can be a vector or a matrix of any dimension
%
% minDist is the minimum distance between two peaks (local maxima)
% minDist should be a vector in which each argument corresponds to it's
% relevant dimension OR a number which is the minimum distance for all
% dimensions
%
% Example:
% a = randn(100,30,10);
% minDist = [10 3 5];
% peaks = localMaximum(a,minDist);
% 
% To recieve the subscript instead of the index use:
% [xIn yIn zIn] = localMaximum(a,minDist);
%
% To find local minimum call the function with minus the variable:
% valleys = localMaximum(-a,minDist);

    if nargin < 2
        minDist = size(x)/10;
    end
    
    dimX = length ( size(x) );
    if length(minDist) ~= dimX
        % In case minimum distance isn't defined for all of x dimensions
        % I use the first value as the default for all of the dimensions
        minDist = minDist( ones(dimX,1) );
    end
    
    % validity checks
    minDist = ceil(minDist);  %%ROUND
    minDist = max( [minDist(:)' ; ones(1,length(minDist))] ); %%minDist>=1
    minDist = min( [minDist ; size(x)] );
    
    se = ones(minDist);
    X = imdilate(x,se);
    f = find(x == X);
    
    [varargout{1:nargout}] = ind2sub( size(x), f );
    
